/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Calculations;

import java.awt.Color;

public class Colors {
    public static Color C_BLUE_HEADING = Colors.Color_hsv(180.0, 20.0, 97.0);
    public static Color C_DIVIDER = Colors.Color_hsv(0.0, 0.0, 90.0);
    public static Color C_ERROR = Colors.Color_hsv(0.0, 70.0, 97.0);
    public static Color C_CLEAR = Colors.Color_hsv(0.0, 0.0, 0.0, 0.0);
    public static Color C_YELLOW = Colors.Color_hsv(51.0, 68.0, 100.0);
    public static Color C_GRAY1 = Colors.Color_hsv(0.0, 0.0, 99.0);
    public static Color C_GRAY2 = Colors.Color_hsv(0.0, 0.0, 90.0);
    public static Color C_GRAY3 = Colors.Color_hsv(0.0, 0.0, 85.0);
    public static Color C_RED = Colors.Color_hsv(0.0, 80.0, 100.0);
    public static Color C_GREEN = Colors.Color_hsv(120.0, 80.0, 100.0);

    public static Color Color_hsv(double h, double s, double v, double a) {
        if ((a %= 101.0) < 0.0) {
            a += 101.0;
        }
        a = Math.min(a, 100.0);
        a = a / 100.0 * 255.0;
        Color temp = Colors.Color_hsv(h, s, v);
        return new Color(temp.getRed(), temp.getGreen(), temp.getBlue(), (int)a);
    }

    public static Color Color_hsv(double h, double s, double v) {
        double b;
        double g;
        double r;
        if ((h %= 360.0) < 0.0) {
            h += 360.0;
        }
        if ((s %= 101.0) < 0.0) {
            s += 101.0;
        }
        if ((v %= 101.0) < 0.0) {
            v += 101.0;
        }
        h = Math.min(h, 360.0);
        s = Math.min(s, 100.0);
        v = Math.min(v, 100.0);
        v /= 100.0;
        if ((s /= 100.0) == 0.0) {
            double b2;
            double g2 = b2 = v;
            double r2 = b2;
            return new Color((int)(r2 * 255.0), (int)(g2 * 255.0), (int)(b2 * 255.0));
        }
        int i = (int)Math.floor(h /= 60.0);
        double f = h - (double)i;
        double p = v * (1.0 - s);
        double q = v * (1.0 - s * f);
        double t = v * (1.0 - s * (1.0 - f));
        switch (i) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            default: {
                r = v;
                g = p;
                b = q;
            }
        }
        return new Color((int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0));
    }

    public static Color weightedAverageColor(Color c1, Color c2, double pC2) {
        if (pC2 > 1.0) {
            pC2 = 1.0;
        }
        if (pC2 < 0.0) {
            pC2 = 0.0;
        }
        double pC1 = 1.0 - pC2;
        double red = (double)c1.getRed() * pC1 + (double)c2.getRed() * pC2;
        double green = (double)c1.getGreen() * pC1 + (double)c2.getGreen() * pC2;
        double blue = (double)c1.getBlue() * pC1 + (double)c2.getBlue() * pC2;
        double alpha = (double)c1.getAlpha() * pC1 + (double)c2.getAlpha() * pC2;
        try {
            return new Color((int)red, (int)green, (int)blue, (int)alpha);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Red = " + red);
            System.out.println("pC1 = " + pC1);
            System.out.println("pC2 = " + pC2);
            e.printStackTrace();
            throw new Error("EXIT");
        }
    }

    public static int rgbToRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int rgbToGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int rgbToBlue(int color) {
        return color & 0xFF;
    }

    public static int rgbToAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int makeRgb(int red, int green, int blue) {
        int rgb = red;
        rgb = (rgb << 8) + green;
        rgb = (rgb << 8) + blue;
        return rgb;
    }

    public static Color color_random() {
        return new Color((int)(Math.random() * 255.0), (int)Math.random() * 255, (int)Math.random() * 255);
    }
}

